﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LapAroundCS.Application
{
    public partial class Form1 : Form
    {
        RPCSharedBrokerSessionMgr2.ISharedBrokerClient BrokerClient;
        RPCSharedBrokerSessionMgr2.ISharedBrokerErrorCode Success;
        RPCSharedBrokerSessionMgr2.SharedBroker rpcBroker;
        RPCSharedBrokerSessionMgr2.ISharedBrokerShowErrorMsgs ShowErrMsgs;
        bool blnConn = false;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            treeView1.Nodes.Clear();
            comboBox1.Items.Clear();

            comboBox1.Items.Add("AJJ3 GUI EXCEL RETRIEVE1");
            comboBox1.Items.Add("AJJ3 GUI SORT RETRIEVE");
            comboBox1.Items.Add("AJJ3 GUI PRINT RETRIEVE");
            comboBox1.Items.Add("AJJ3 GUI GET VARIABLE VALUE");
            comboBox1.Items.Add("AJJ3 GUI KEY CHECK");

            vsATextBox.Text = "1";
        }

        private void clearButton_Click(object sender, EventArgs e)
        {
            treeView1.Nodes.Clear();
        }

        public string CallRPC(string strRPC, string ServerPort, params object[] strP)
        {
            string strData;
            string strParams;
            string login;
            string ErrorMsg ;

            if (rpcBroker == null)
            {
                blnConn = false;
            }

            // Create RPC Broker
            try
            {
                if (rpcBroker == null || blnConn == false)
                {
                    rpcBroker = new RPCSharedBrokerSessionMgr2.SharedBroker();
                    //ShowErrMsgs = 1 ;
                    int clientid;
                    login = "" + Convert.ToChar(28) + "" + Convert.ToChar(28) + "9203whm" + Convert.ToChar(28) +"]]gow11e"+ Convert.ToChar(28)+ "" + Convert.ToChar(28) + '1';
                    // Connect with Client name, Type, Server:Port, etc.
                    //if (rpcBroker.BrokerConnect(comboBox1.Text, BrokerClient, ServerPort, false, false, 0, out clientid) != RPCSharedBrokerSessionMgr.ISharedBrokerErrorCode.Success)
                    if (rpcBroker.BrokerConnect(comboBox1.Text, BrokerClient, ServerPort, false, false, true, ShowErrMsgs, 0, ref login, out clientid, out ErrorMsg) != RPCSharedBrokerSessionMgr2.ISharedBrokerErrorCode.Success)
                    {
                        blnConn = false;
                        throw new Exception("Unable to connect to host or invalid login");
                        //return "";
                    }

                    if (rpcBroker.BrokerSetContext("GUIFM SQL SERVER") != RPCSharedBrokerSessionMgr2.ISharedBrokerErrorCode.Success)
                    {
                        MessageBox.Show("Error creating context");
                        return "";
                    }
                    
                    blnConn = true;
                }
            }
            catch (Exception ex)
            {
                throw new Exception("Error creating RPC Broker.\n" + ex.ToString(), ex);
            }

            strParams = "";
            foreach(object vntItem in strP)
            {
                strParams = strParams + "L " + vntItem.ToString() + Convert.ToChar(29);
            }

            if (strParams.Equals("L " + Convert.ToChar(29)))
            {
                strParams = string.Empty;
            }

            //if(comboBox1.SelectedIndex == 3)
            //    strParams = "L DUZ" + Convert.ToChar(29);

            //if (comboBox1.SelectedIndex == 4)
            //    strParams = "L AJJ3 GUI FM SQLSERVER" + Convert.ToChar(29);

            if (string.IsNullOrEmpty(strParams))
            {
                MessageBox.Show("DUZ or Other Input\nParameter required.");
                return string.Empty;
            }

            strData = string.Empty;
            int rpcCallId;
            try
            {
                rpcBroker.BrokerCall(strRPC, strParams, 0, out strData, out rpcCallId);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
                rpcBroker.BrokerDisconnect();
            }

            // Apply retrieved DUZ to vsATextBox
            if (!string.IsNullOrEmpty(strData) && comboBox1.SelectedIndex == 3)
            {
                string[] result = strData.Split(new string[] { "\r", "\n" }, StringSplitOptions.None);
                vsATextBox.Text = result[0];
            }

            return strData;
        }

        private void joinStringsButton_Click(object sender, EventArgs e)
        {
            ValidatedString vsA = new ValidatedString(vsATextBox.Text);
            ValidatedString vsB = new ValidatedString(vsBTextBox.Text);

            // + operator overloaded in ValidatedString.cs class
            ValidatedString vsResult = vsA + vsB;

            //vsResultTextbox.Text = vsResult.Value;
            object strStDt = vsATextBox.Text + vsBTextBox.Text;

            if (comboBox1.SelectedIndex < 3)
            {
                // pass DUZ
                strStDt = vsATextBox.Text;
            }
            else
            {
                strStDt = vsBTextBox.Text;
            }

            vsResultTextbox.Text = strStDt.ToString();
            //string stR = CallRPC(comboBox1.Text, "ecptest.houston.med.va.gov:19019", strStDt);
            string stR = CallRPC(comboBox1.Text, "192.168.1.108:9200", strStDt);

            treeView1.Nodes.Clear();
            TreeNode root = treeView1.Nodes.Add("Root");
            TreeNode node1;

            string[] astrLines = stR.Split(new string[] { "\r\n", "\n" }, StringSplitOptions.None);

            foreach (string strLine in astrLines)
            {
                if (!string.IsNullOrEmpty(strLine))
                {
                    node1 = root.Nodes.Add(strLine);
                    node1.Tag = "1";
                }
            }

            root.Expand();
        }
    }
}
